##################### Seleo das 40 espcies com maiores volumes movimentados ####################

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Carrega os pacotes necessrio para ler os arquivos
    library(data.table)
    library(dplyr)
    library(tidyr)
  
# L a planilha sisdof
    sisdof <- fread("Movimentacao Geral 2012 a 2017.Final.csv",
                    colClasses = c("character","character", "character", 
                                   "character", "character", "character",
                                   "character", "character", "character",
                                   "character", "character", "character",
                                   "character", "character", "character",
                                   "numeric", "numeric", "character"))
    
# Deleta coluna V1 criada pelo comando fread.
    sisdof <- sisdof[, -c("V1")]
    

# Transforma a classe do Preco.Total para numerico
    sisdof$Preco.Total <- as.numeric(sisdof$Preco.Total)
    
# Funcao para gerar o subset sisdof_tora
tora_rank<- function(sisdof_tora) {
    
# Cria a planilha sisdof_tora com o subset das movimentaes de Toras e Toretes
    sisdof_tora <- subset(sisdof, (Produto == "toretes" | Produto == "tora" ))
    
# Retira os valores das movimentaes de Ptios e Declarao de Importao
    sisdof_tora <- sisdof_tora[!sisdof_tora$Tipo.de.Origem == "Patio"]
    sisdof_tora <- sisdof_tora[!sisdof_tora$Tipo.de.Origem == "Declaracao.de.Importacao"]
    
# Retira os valores das movimentaes de toras com guias GF3 ou GF3i, ou DOF.Isento.de.CTF, para representar melhor a anise de origem de toras
    sisdof_tora <- subset(sisdof_tora, (Tipo.de.Guia != "GF3" &
                                            Tipo.de.Guia != "GF3i" &
                                            Tipo.de.Guia != "DOF.Isento.de.CTF"))
    
# Lista as categorias de Tipo.de.Guia
    # unique(sisdof_tora$Tipo.de.Guia)
    
# Lista as categorias de Tipo.de.Origem  
    # unique(sisdof_tora$Tipo.de.Origem)
    
# Lista as categorias de Produtos presentes na planilha sisdof_tora
    # unique(sisdof_tora$Produto)
    
#### Selecao de especies mais movimentadas ####   
    
# Agrega a soma do volume total e do preo total conforme as colunas escolhidas
    sisdoftora_esp <- sisdof_tora[, .(sum(Volume.Total, na.rm = TRUE), sum(Preco.Total, na.rm = TRUE)),
                                  by = .(Especie,
                                         Portaria.443,
                                         Cites,
                                         Grupo)]
    
# Renomeia as colunas V1 e V2  
    sisdoftora_esp <- rename(sisdoftora_esp,
                             "Volume.Total" = "V1",
                             "Preco.Total" = "V2")
    
# Cria a coluna "Ranking" com a ordem decrescente de volume por espcie. 
    # deve-se adicionar o sinal negativo "-" antes da coluna a ordenar para ficar descrescente. 
    sisdoftora_esp$Ranking <- rank(-sisdoftora_esp$`Volume.Total`)
    
# Cria uma coluna com o valor percentual do volume movimentado  
    sisdoftora_esp$Vol.perc <- (sisdoftora_esp$`Volume.Total`*100)/sum(sisdoftora_esp$`Volume.Total`)
    
# Cria a coluna "Cumulado" com o volume acumulado
    sisdoftora_esp$Cumulado <- cumsum(sisdoftora_esp$Vol.perc)
    
# Ordena de forma decrescente em relao ao volume movimentado
    sisdoftora_esp <- sisdoftora_esp[order(sisdoftora_esp$`Volume.Total`, decreasing = TRUE),]
        
}

sisdoftora_esp <- tora_rank()
  
# Cria o subset das espcies mais movimentadas, excluindo as especies cujos nomes cientificos
# sao composto apenas do genero (ex: Qualea sp)
  sisdoftora_esp_top <- sisdoftora_esp[-grep("\\ssp$", sisdoftora_esp$Especie)]
  
  # Elimina a espcie extica Eucalyptus pellita
  sisdoftora_esp_top <- sisdoftora_esp_top[sisdoftora_esp_top$Especie != "Eucalyptus pellita"]
  
  sisdoftora_esp_top <- sisdoftora_esp_top[1:25]

# Cria o Grupo.1 em sisdof$Grupo com as espcies mais movimentadas
  sisdof$Grupo[!is.na(match(sisdof$Especie, 
                       sisdoftora_esp_top$Especie))] <- "Grupo.1"
  
  # sisdof1 <- sisdof[sample(nrow(sisdof), 1000),]
  
################################## Volumes de toras Ameaadas #######################################

sisdoftora_esp <- tora_rank()
  
# Cria a planilha ameaadas com o subset das movimentaes de TORAS
  sisdoftora_esp_top_443 <- subset(sisdoftora_esp, (Portaria.443 == "CR" |
                                      Portaria.443 == "EN"|
                                      Portaria.443== "VU"))
  
# Cria o subset das espcies mais movimentadas das especies contidas na Portaria 443.
  sisdoftora_esp_top_443 <- sisdoftora_esp_top_443[sisdoftora_esp_top_443$Grupo != "Grupo.1"]
  sisdoftora_esp_top_443 <- sisdoftora_esp_top_443[1:5]
  
# Cria o Grupo.2 em sisdof$Grupo.X com as espcies mais movimentadas
  sisdof$Grupo[!is.na(match(sisdof$Especie, 
                            sisdoftora_esp_top_443$Especie))] <- "Grupo.2"
 
################################## Volumes de toras Cites @@#######################################

sisdoftora_esp <- tora_rank()

# Cria a planilha cites com o subset das movimentaes de TORAS
  sisdoftora_esp_top_cites <- subset(sisdoftora_esp, (Cites == "I" |
                                  Cites == "II"|
                                  Cites== "III"))
  
# Cria o subset das espcies mais movimentadas das especies contidas na Portaria 443.
  sisdoftora_esp_top_cites <- sisdoftora_esp_top_cites[(sisdoftora_esp_top_cites$Grupo != "Grupo.1" &
                                                            sisdoftora_esp_top_cites$Grupo != "Grupo.2")]
  sisdoftora_esp_top_cites <- sisdoftora_esp_top_cites[1:5]
  
# Cria o Grupo.3 em sisdof$Grupo.X com as espcies mais movimentadas
  sisdof$Grupo[!is.na(match(sisdof$Especie, 
                            sisdoftora_esp_top_cites$Especie))] <- "Grupo.3"
  
# Remove as planilhas intermediaria
  rm( sisdoftora_esp, sisdoftora_esp_top, sisdoftora_esp_top_443, sisdoftora_esp_top_cites)
  
# Escreve o arquivo .csv da planilha sisdof aps padronizar todas as variveis  
  write.csv(sisdof, file = "Movimentacao Geral 2012 a 2017.Final.Ranking.csv")
  
#### Toras ####
  
# Cria a planilha sisdof_tora com o subset das movimentaes de Toras e Toretes
  sisdof_tora <- subset(sisdof, (Produto == "toretes" | Produto == "tora" ))
  
# Retira os valores das movimentaes de Ptios e Declarao de Importao
  sisdof_tora <- sisdof_tora[!sisdof_tora$Tipo.de.Origem == "Patio"]
  sisdof_tora <- sisdof_tora[!sisdof_tora$Tipo.de.Origem == "Declaracao.de.Importacao"]
  
# Retira os valores das movimentaes de toras com guias GF3 ou GF3i, ou DOF.Isento.de.CTF, para representar melhor a anise de origem de toras
  sisdof_tora <- subset(sisdof_tora, (Tipo.de.Guia != "GF3" &
                                          Tipo.de.Guia != "GF3i" &
                                          Tipo.de.Guia != "DOF.Isento.de.CTF"))

# Escreve o arquivo .csv da planilha sisdof_tora
  write.csv(sisdof_tora, file ="SisDOF-toras_2012_2017.csv")
  
#### Produto Acabado ####
  
# Cria a planilha sisdof_produto com o subset das movimentaes aos consumidores finais.
  sisdof_produto <- sisdof[sisdof$Cadastro.Destino ==  "Consumidor.Final"]
  
# Retira os valores das movimentaes de Declarao de Importao
  sisdof_produto <- sisdof_produto[!sisdof_produto$Tipo.de.Origem == "Declaracao.de.Importacao"]
  
# Lista as categorias de Tipo.de.Guia
  # unique(sisdof_produto$Tipo.de.Guia)
  
# Lista as categorias de Produtos presentes na planilha sisdof_produto
  # unique(sisdof_produto$Produto)
  
# Escreve o arquivo .csv da planilha sisdof_produto
  write.csv(sisdof_produto, file = "SisDOF_Destino_2012_2017.csv")
  
# Deleta planilhas
  rm(sisdof, sisdof_produto, sisdof_tora)
  
  
  